function [fData, wave] = sensorColorFilter(cfType,varargin)
% Create color filters for use in a sensor
%
%     [fData, wave] = sensorColorFilter(cfType,varargin)
%
% Gateway routine for creating sensor color filter curves.
%
%  Gaussian:(Others to come)
%
%  
% Examples:
%  cfType = 'gaussian'; wave = [400:10:700];
%  cPos = [500,600]; width = [40,40];
%  fData = sensorColorFilter(cfType,wave, cPos, width);
%  plot(wave,fData);
%
%  [fData,wave] = sensorColorFilter(cfType);
%  plot(wave,fData)
%  plot(wave,sum(fData,2))
%
%  cfType = 'gaussian'; wave = [350:850];
%  cPos = 450:50:750; width = ones(size(cPos))*25;
%  fData = sensorColorFilter(cfType,wave, cPos, width);
%  plot(wave,fData)
%
%  
% Copyright ImagEval Consultants, LLC, 2010


if ieNotDefined('cfType'), cfType = 'gaussian'; end

switch lower(cfType)
    case 'gaussian'  
        if isempty(varargin), wave = 400:700; 
        else wave = varargin{1}; end
        if length(varargin)<2, cPos = [450,550,650]; 
        else cPos = varargin{2}; end
        if length(varargin)<3, widths = ones(size(cPos))*40; 
        else widths = varargin{3}; end
        if length(varargin)<4, amplitudes = ones(size(cPos)); 
        else amplitudes = varargin{4}; end
        
        % Since this is transmittance, amplitudes can't be more than 1
        if(max(amplitudes) > 1)
            amplitudes = amplitudes./max(amplitudes);
        end
            
        nFilters = length(cPos);
        fData = zeros(length(wave),nFilters);
        for ii=1:nFilters
            fData(:,ii) = amplitudes(ii)*exp(-1/2*( (wave-cPos(ii))/(widths(ii))).^2);
        end
        % plot(wave,fData)
    otherwise
        error('Unknown filter type')
end

return



